/*
 * Decompiled with CFR 0.152.
 */
package irc.security.prv;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import irc.security.SecuredProvider;
import irc.security.prv.SpecificMSSecuredServerSocket;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class SpecificMSSecuredProvider
implements SecuredProvider {
    public Socket getSocket(String string, Integer n) throws UnknownHostException, IOException {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
            return new Socket(string, (int)n);
        }
        catch (Throwable throwable) {
            return new Socket(string, (int)n);
        }
    }

    public ServerSocket getServerSocket(Integer n) throws IOException {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
            return new SpecificMSSecuredServerSocket(n);
        }
        catch (Throwable throwable) {
            return new SpecificMSSecuredServerSocket(n);
        }
    }

    public FileInputStream getFileInputStream(File file) throws IOException {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
            return new FileInputStream(file);
        }
        catch (Throwable throwable) {
            return new FileInputStream(file);
        }
    }

    public Integer getFileSize(File file) {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
            return new Integer((int)file.length());
        }
        catch (Throwable throwable) {
            return new Integer((int)file.length());
        }
    }

    public FileOutputStream getFileOutputStream(File file) throws IOException {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
            return new FileOutputStream(file);
        }
        catch (Throwable throwable) {
            return new FileOutputStream(file);
        }
    }

    public FileDialog getFileDialog(Frame frame, String string, int n) {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.UI);
            return new FileDialog(frame, string, n);
        }
        catch (Throwable throwable) {
            return new FileDialog(frame, string, n);
        }
    }

    public File getLoadFile(String string) {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.UI);
            Frame frame = new Frame();
            FileDialog fileDialog = new FileDialog(frame, string, 0);
            fileDialog.show();
            File file = null;
            if (fileDialog.getFile() != null) {
                file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            }
            fileDialog.hide();
            fileDialog.dispose();
            frame.dispose();
            return file;
        }
        catch (Throwable throwable) {
            Frame frame = new Frame();
            FileDialog fileDialog = new FileDialog(frame, string, 0);
            fileDialog.show();
            File file = null;
            if (fileDialog.getFile() != null) {
                file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            }
            fileDialog.hide();
            fileDialog.dispose();
            frame.dispose();
            return file;
        }
    }

    public File getSaveFile(String string) {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.UI);
            Frame frame = new Frame();
            FileDialog fileDialog = new FileDialog(frame, string, 1);
            fileDialog.show();
            File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            fileDialog.hide();
            fileDialog.dispose();
            frame.dispose();
            return file;
        }
        catch (Throwable throwable) {
            Frame frame = new Frame();
            FileDialog fileDialog = new FileDialog(frame, string, 1);
            fileDialog.show();
            File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            fileDialog.hide();
            fileDialog.dispose();
            frame.dispose();
            return file;
        }
    }

    public File getSaveFile(String string, String string2) {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.UI);
            Frame frame = new Frame();
            FileDialog fileDialog = new FileDialog(frame, string2, 1);
            fileDialog.setFile(string);
            fileDialog.show();
            File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            fileDialog.hide();
            fileDialog.dispose();
            frame.dispose();
            return file;
        }
        catch (Throwable throwable) {
            Frame frame = new Frame();
            FileDialog fileDialog = new FileDialog(frame, string2, 1);
            fileDialog.setFile(string);
            fileDialog.show();
            File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            fileDialog.hide();
            fileDialog.dispose();
            frame.dispose();
            return file;
        }
    }

    public InetAddress getLocalHost() throws UnknownHostException {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
            InetAddress[] inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            return inetAddressArray[inetAddressArray.length - 1];
        }
        catch (Throwable throwable) {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            return inetAddressArray[inetAddressArray.length - 1];
        }
    }

    public String resolve(InetAddress inetAddress) {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
            return inetAddress.getHostName();
        }
        catch (Throwable throwable) {
            return inetAddress.getHostName();
        }
    }

    public boolean tryProvider() {
        try {
            PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
            PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
            PolicyEngine.assertPermission((PermissionID)PermissionID.UI);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String getName() {
        return "Microsoft Internet Explorer Security Provider";
    }
}

